// ignore_for_file: public_member_api_docs, sort_constructors_first
// ignore_for_file: constant_identifier_names

import 'dart:ui';

import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/utils/my_color.dart';

class MyStatus {
  static const String ENABLE = '1';
  static const String DISABLE = '0';

  static const String YES = '1';
  static const String NO = '0';

  static const String VERIFIED = '1';
  static const String UNVERIFIED = '0';

  static const String PAYMENT_INITIATE = '0';
  static const String PAYMENT_SUCCESS = '1';
  static const String PAYMENT_PENDING = '2';
  static const String PAYMENT_REJECT = '3';

  static const String TICKET_OPEN = '0';
  static const String TICKET_ANSWER = '1';
  static const String TICKET_REPLY = '2';
  static const String TICKET_CLOSE = '3';

  static const String PRIORITY_LOW = '1';
  static const String PRIORITY_MEDIUM = '2';
  static const String PRIORITY_HIGH = '3';

  static const String USER_ACTIVE = '1';
  static const String USER_BAN = '0';

  static const String KYC_UNVERIFIED = '0';
  static const String KYC_PENDING = '2';
  static const String KYC_VERIFIED = '1';

  static const String GOOGLE_PAY = '5001';

  static const String CUR_BOTH = '1';
  static const String CUR_TEXT = '2';
  static const String CUR_SYM = '3';

  static const String SINGLE_ITEM = '1';
  static const String EPISODE_ITEM = '2';

  static const String FREE_VERSION = '0';
  static const String PAID_VERSION = '1';
  static const String RENT_VERSION = '2';

  static const String TRAILER = '1';

  static const String CURRENT_SERVER = '0';
  static const String FTP_SERVER = '1';
  static const String WASABI_SERVER = '2';
  static const String DIGITAL_OCEAN_SERVER = '3';

  static const String WATCH_PARTY_REQUEST_PENDING = '0';
  static const String WATCH_PARTY_REQUEST_ACCEPTED = '1';
  static const String WATCH_PARTY_REQUEST_REJECTED = '2';

  static const String FORMAT_SKIPABLE = '1';
  static const String FORMAT_NONSKIPABLE = '2';

  static const String REQUEST_ITEM_PENDING = '0';
  static const String REQUEST_ITEM_ACCEPTED = '1';
  static const String REQUEST_ITEM_REJECTED = '2';

  static const String VOTE_UP = '1';
  static const String VOTE_DOWN = '2';
  static const String SINGLE = "1";
  static const String EPISODE = "2";

  static String getItemStatus(String status) {
    switch (status) {
      case SINGLE:
        return "Single";
      case EPISODE:
        return "Episode";
      default:
        return MyStrings.trailer;
    }
  }

  static StatusTypeNColor requestItemStatus(String status) {
    switch (status) {
      case REQUEST_ITEM_PENDING:
        return StatusTypeNColor(status: "Pending", color: MyColor.pendingColor);
      case REQUEST_ITEM_ACCEPTED:
        return StatusTypeNColor(status: "Accepted", color: MyColor.greenSuccessColor);
      default:
        return StatusTypeNColor(status: "Rejected", color: MyColor.redCancelTextColor);
    }
  }
}

class StatusTypeNColor {
  String status;
  Color color;
  StatusTypeNColor({
    required this.status,
    required this.color,
  });
}
